<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;

class PaymentRequest extends FormRequest
{
   
    protected function failedValidation(Validator $validator) {
        throw new ValidationException($validator, $this->validationError($validator));
    }

    
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'csparty_id' => 'required | integer',
            'plot_id' => 'required | integer',
            'amount' => 'required | integer',
            'transaction_id' => 'required | string',
            'payment_mod' => 'nullable | string',
            'transaction_date' => 'nullable | date',
            'transaction_category' => 'string | in:installment,token,possession',
        ];
    }
}