<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;

class CartRequest extends FormRequest
{
    protected function failedValidation(Validator $validator)
    {
        throw new ValidationException($validator, $this->validationError($validator));
    }

    protected function validationError(Validator $validator)
    {
        $errors = $validator->errors();
        return response()->json(['errors' => $errors], 422);
    }

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        if ($this->getMethod() == "POST")
            return [
                'plan_type' => 'required|string',
                'total_amount' => 'required|integer',
                'plot_size' => 'required',
                'Project_ID' => 'required',
                'UP_ID' => 'required',
                'down_payment' => 'required|integer',
                'possession' => 'required|integer',
                'installment' => 'required|integer',
                'customer' => 'integer|nullable'
            ];
        else
            return [
                'plan_type' => 'string',
                'Project_ID' => 'string',
                'UP_ID' => 'string',
                'total_amount' => 'integer',
                'plot_size' => 'nullable',
                'down_payment' => 'integer',
                'possession' => 'integer',
                'installment' => 'integer',
                'customer' => 'integer|nullable'
            ];
    }
}
