<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TransactionController extends Controller
{
    public function fetchTransaction()
    {
        $data = Transaction::select('transactions.plot_no','transactions.customer_id','transactions.amount','transactions.id as transactionId','csparty.*')
        ->leftJoin('csparty','transactions.customer_id' ,'csparty.id')
        ->where('update_able' , '1')->get();
        if(!$data->isEmpty())
        {
            return response()->json([
               'data'=> $data,
            ],200);
        }else{
            return response()->json([
               'message' => 'no record found!',
            ],404);
        }
    }
    public function changeUpdatedStatus(Request $request)
    {
        // dd($request);
        $ids = $request->update_id;
        $execute = Transaction::whereIn('id', $ids)
        ->update(['update_able' => '0']);
        $update = $this->changeStatusPlot($request->plot_no);
        if($update)
        {
            return $execute ? $this->successUpdateResponse($ids) : $this->errorUpdateResponse();
        }
    }

    public function changeStatusPlot($plotIds)
    {
        $query = DB::table('housing_unit_plots')
        ->whereIn('UP_ID', $plotIds)
        ->update(['UP_Status' => 'TOKEN']);
        if($query)
        {
            return response()->json([
                'message'=>'Plot Status Changes Successfully'
            ],200);
        }else{
            return response()->json([
                'message'=>'Something Went Wrong Try Again!'
            ],400);
        }
    }
}
