<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\HousingUnitPlot;
use App\Models\SaleDeedIns;
use App\Models\SaleDeedMain;

class ReportController extends Controller
{
    public function dashboardReport()
    {
       $properties = HousingUnitPlot::count();
       $available = HousingUnitPlot::where('UP_Status','AVAILABLE')->count();
       $installments = SaleDeedIns::count();
       $sale = SaleDeedMain::sum('Total_Price');
       
        $data = [
            'properties' => $properties,
            'properties_for_sale' => $available,
            'installments' => $installments,
            'earning' => $sale,
        ];

        return response()->json([
           'data' => $data,
        ],200);
    }
}
