<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\LedgerDetailBpv;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerDetailBPVController extends Controller
{
    use ApiResponseTrait;


    public function store(Request $request)
    {
      $stored = LedgerDetailBpv::insert($request->all());
      return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = LedgerDetailBpv::find($request->id);
        if(!$record)  return $this->generalResponse('RECORD_NOT_FOUND', 404);
        $request->merge(['updated_status' => '1']);
        $record->update($request->all());
        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }
    protected function index(Request $request , $id = null )
    {
        $serverId[] = $request->server_id;
        $limit = $request->input('limit', 25);
        $data = LedgerDetailBpv::whereId($id)
        ->whereServerId($serverId)
        ->Where('Comp_ID', COMPANY_ID)
        ->whereUpdateAble($request->updated_status)
        ->paginate($limit);
        return $data ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }
    public function serverId()
    {
      $data = LedgerDetailBpv::select('server_id as id')->get();
      return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
       $serverIds= $request->server_id;
       $execute = DB::table('ledger_detail_bpvs')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
            return $execute ? $this->successUpdateResponse($serverIds) :  $this->errorUpdateResponse();    
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        foreach ($request->data as $list) {
            $result = DB::table('ledger_detail_bpvs')
                        ->where('server_id', $list['server_id'])
                        ->update([
                            'Ledger_ID' => $list['Ledger_ID'],
                            'Comp_ID' => $list['Comp_ID'],
                            'P_Mode' => $list['P_Mode'],
                            'Cheque_No_ID' => $list['Cheque_No_ID'],
                            'Trans_No' => $list['Trans_No'],
                            'Account_Title' => $list['Account_Title'],
                            'Account_No' => $list['Account_No'],
                            
                        ]);
            if ($result !== false)  $successCount++;
        }
    
        return $successCount === $totalCount ? $this->successUpdateResponse("All records updated successfully.") : $this->errorUpdateResponse("Failed to update some records.");
    }
}
