<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\HousingSaleTokenChill;
use Illuminate\Http\Request;

use App\Traits\ApiResponseTrait;
use Illuminate\Support\Facades\DB;


class HousingSaleTokenChillController extends Controller
{
    use ApiResponseTrait;

    public function store(Request $request)
    {
        $stored = HousingSaleTokenChill::insert($request->all());
        if ($stored)
            return $this->successInsertResponse($stored);
        else
            return $this->errorInsertResponse();
    }
 
    protected function update(Request $request)
    {
        $record = HousingSaleTokenChill::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);

        $request->merge(['updated_status' => '1']);
        $record->update($request->all());

        return $record
            ? $this->successUpdateResponse($record)
            : $this->errorUpdateResponse();
    }

    protected function index(Request $request, $id = null)
    {

        $serverId = $request->server_id;
        $limit = $request->input('limit', DEFAULT_LIMIT);

        $data = HousingSaleTokenChill::whereId($id)
            ->Where('Comp_ID', COMPANY_ID)
            ->whereServerId($serverId)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);
            
        return ($data->total() > 0)  ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }

    public function serverId()
    {
        $data = HousingSaleTokenChill::select('server_id as id')->Where('Comp_ID', COMPANY_ID)->get();
        return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    
    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = DB::table('street_lanes')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();

    }

    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        foreach ($request->data as $list) {
            $result = DB::table('street_lanes')
                ->where('server_id', $list['server_id'])
                ->update([
                    'comp_id' => $list['Comp_ID'],
                    'husl_name' => $list['HUSL_Name'],
                    'remarks' => $list['Remarks'],
                    'b_group' => $list['B_Group'],
                ]);

            if ($result !== false)
                $successCount++;
        }
        if ($successCount === $totalCount)
            return $this->successUpdateResponse("All records updated successfully.");
        else
            return $this->errorUpdateResponse("Failed to update some records.");
    }
    public function addToSql(Request $request)
    {
        $server_ids = explode(',', $request->server_id);
        $data = HousingSaleTokenChill::whereNotIn('server_id', $server_ids)->Where('Comp_ID', COMPANY_ID)->get();
        return $data;
    }
}