<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;


class GalleryController extends Controller
{
    public function storeImage(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'category' => 'required|string',
            'main_img' => 'required',
            'img_1' => 'nullable',
            'img_2' => 'nullable',
            'img_3' => 'nullable',
            'img_4' => 'nullable',
            'img_5' => 'nullable',
        ]);
    
        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed',
                'errors' => $validation->errors(),
            ], 422);
        }
        
        $image = new Image();
        $image->category = $request->category;
        $uploadPath = public_path('gallery-images');
    
        if ($request->hasFile('main_img')) {
            $image->main_img = $this->uploadImage($request->file('main_img'), $uploadPath);
        }
        
        foreach (['img_1', 'img_2', 'img_3', 'img_4', 'img_5'] as $imgField) {
            if ($request->hasFile($imgField)) {
                $image->$imgField = $this->uploadImage($request->file($imgField), $uploadPath);
            }
        }
    
        if ($image->save()) {
            return response()->json([
                'message' => 'Images uploaded successfully!',
                'data' => $image
            ], 201);
        }
    
        return response()->json([
            'message' => 'Something went wrong, please try again!' ,
        ], 400);
    }

    public function get(Request $request , $id=null)
    {

        $data = Image::where('status','active');
        if(!is_null($id))
        {
             $data->where('id' ,$id);
        }
       $data = $data->get();
        if(!$data->isEmpty())
        {
            return response()->json([
                 'gallery' => $data
            ],200);
        }else{
            return response()->json([
                'message' => 'no record found !'
            ],404);
        }
    }

    public function update(Request $request , $id)
    {
        $validation = Validator::make($request->all(), [
            'category' => 'required|string',
            'main_img' => 'nullable|max:2048',
            'img_1' => 'nullable|max:2048',
            'img_2' => 'nullable|max:2048',
            'img_3' => 'nullable|max:2048',
            'img_4' => 'nullable|max:2048',
            'img_5' => 'nullable|max:2048',
        ]);
    
        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed',
                'errors' => $validation->errors(),
            ], 422);
        }

        $image = Image::find($id);
        if(!$image)
        {
            return response()->json([
                'message' => 'no record found !'
            ],422);
        }
        $image->category = $request->category;
        $uploadPath = public_path('gallery-images');
    
        if ($request->hasFile('main_img')) {
            $image->main_img = $this->uploadImage($request->file('main_img'), $uploadPath);
        }
    
        foreach (['img_1', 'img_2', 'img_3', 'img_4', 'img_5'] as $imgField){
            if ($request->hasFile($imgField)) {
                $image->$imgField = $this->uploadImage($request->file($imgField), $uploadPath);
            }else{
                $image->$imgField = null;
            }
        }
    
        if ($image->save()) {
            return response()->json([
                'message' => 'gallery updated successfully!',
                'data' => $image
            ], 201);
        }
    
        return response()->json([
            'message' => 'Something went wrong, please try again!' ,
        ], 400);


    } 

    public function changeStatus($id, $status)
    {
        $validStatuses = ['active', 'inactive', 'deleted'];

        $image = Image::find($id);
        if (!$image) {
            return response()->json([
                'message' => 'No record found!'
            ], 404);
        }

        if (!in_array($status, $validStatuses)) {
            return response()->json([
                'message' => 'Invalid status'
            ], 422);
        }

        $image->status = $status;
        if (!$image->save()) {
            return response()->json([
                'message' => 'Something went wrong, try again!'
            ], 500);
        }

        return response()->json([
            'message' => 'Status changed successfully'
        ], 200);
    }

    
    private function uploadImage($file, $uploadPath)
    {
        $imageName = time() . '_' . Str::random(10) . '.' . $file->getClientOriginalExtension();
        $file->move($uploadPath, $imageName);
        return url('public/gallery-images/' . $imageName);
    }
}
