<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    public function UpdatedStatus($model, Request $request)
    {
    
        if (!$request->has('server_id'))
            return $this->generalResponse("Server ID(s) missing.", HTTP_BAD_REQUEST);

            
        $serverIds = $request->server_id;
        if (empty($serverIds))
            return $this->generalResponse("No server IDs provided.", HTTP_BAD_REQUEST);
        

        $execute = $model::whereIn('server_id', $serverIds)->update(['updated_status' => '0']);
        return $execute ? $this->successResponse(null, RECORD_UPDATED, HTTP_OK) : $this->generalResponse(GENERAL_ERROR . " " . RETRY_LATER, HTTP_BAD_REQUEST);
        
    }

    public function setDefaultValue($value, $defaultValue = null) {

        if(is_null($value) || empty($value))
            return  $defaultValue;
        return $value;
    }
}