<?php

namespace App\Http\Controllers;

use App\Http\Requests\CartRequest;
use App\Models\Cart;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CartController extends Controller
{
  use ApiResponseTrait;
  public function addToCart(CartRequest $request)
  {
   
    $created = Cart::create($request->validated());
    return $created
      ? $this->successInsertResponse($created->id)
      : $this->errorInsertResponse();
  }


  public function addToCartOld(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'plan_type' => 'required',
      'total_amount' => 'required',
      'plot_size' => 'required',
      'down_payment' => 'required',
      'possession' => 'required',
      'installment' => 'required',
    ]);

    if ($validation->fails()) {
      return response()->json([
        'message' => 'validation failed!',
        'errors' => $validation->errors(),
      ], 422);
    }

    $cart = new Cart();
    $cart->plan_type = $request->input('plan_type');
    $cart->UP_ID = $request->input('plot_id');
    $cart->total_amount = $request->input('total_amount');
    $cart->plot_size = $request->input('plot_size');
    $cart->down_payment = $request->input('down_payment');
    $cart->possession = $request->input('possession');
    $cart->installment = $request->input('installment');
    $cart->customer = $request->input('customer');
    return $cart->save() ? $this->successInsertResponse($cart->id) : $this->errorInsertResponse();

  }


  public function fetchCart(Request $request)
  {
    $validation = Validator::make($request->all(), [
      'customer' => 'required',
    ]);
    if ($validation->fails()) 
      return response()->json(['message' => 'validation failed!','errors' => $validation->errors()], 422);

    $data = Cart::select(
      'id',
      'plan_type',
      'plot_size',
      'total_amount',
      'down_payment',
      'possession',
      'installment'
    )
      ->where('customer', $request->customer)
      ->orderBy('id', 'desc')
      ->get();

    return !$data->isEmpty() ?  $this->recordFoundResponse($data) : $this->recordNotFoundResponse();

  }

  public function edit(Request $request, $id = null)
  {
    $validation = Validator::make($request->all(), [
      'customer' => 'required',
    ]);

    if ($validation->fails()) {
      return response()->json([
        'message' => 'validation failed!',
        'errors' => $validation->errors(),
      ], 422);
    }
    $cart = Cart::find($id);
    $cart->customer = $request->customer;
    return $cart->save() ? $this->successInsertResponse($cart->id) : $this->errorInsertResponse();
  }

  public function updateCart(CartRequest $request)
  {
    $cart = Cart::find($request->id);
    $cart->plan_type = $request->plan_type;
    $cart->total_amount = $request->total_amount;
    $cart->plot_size = $request->plot_size;
    $cart->down_payment = $request->down_payment;
    $cart->possession = $request->possession;
    $cart->installment = $request->installment;

    return $cart->save() ? 
       response()->json(['message' => 'cart updated successfully'], 200) :
       response()->json(['message' => 'something went wrong! try again!'], 422);
  }

  public function deleteCart(Request $request)
  {
    $validation = Validator::make($request->all(), ['customer_id' => 'required']);

    if ($validation->fails()) 
      return response()->json([
        'message' => 'validation failed !',
        'errors' => $validation->errors(),
      ], 422);
    $delete = Cart::where('customer', $request->customer_id)->delete();

    return $delete ? response()->json(['message' => 'cart deleted successfully'], 200) :
                     response()->json(['message' => 'fail to delete cart , try again!'], 422);
    
  }

}